package gov.va.med.mhv.bluebutton.repository;

import gov.va.med.mhv.bluebutton.model.Study;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface StudyRepository extends JpaRepository<Study, Long> {
	
	@Query("select s from Study s where s.patientId = :patientId")
	List<Study> findByPatientId(@Param("patientId") Long patientId);
	
	@Query("select s from Study s where s.patientId = :patientId and s.studyIdUrn = :studyIdUrn")
	List<Study> findByPatientIdAndStudyIdUrn(@Param("patientId") Long patientId, @Param("studyIdUrn") String studyIdUrn);

	@Query(value ="SELECT PAT.USER_PROFILE_USER_PROFILE_ID FROM PATIENT pat WHERE PATIENT_ID = ?1", nativeQuery=true)
	Long findPatientbyPatientId(Long patientId);

	@Query(value ="SELECT PAT.ICN FROM PATIENT pat WHERE PATIENT_ID = ?1", nativeQuery=true)
	String findICNbyPatientId(Long patientId);

//	@Query(value ="INSERT INTO ACTIVITY (ACTIVITY_ID, USER_PROFILE_ID, STATUS, ACTIVITY_TYPE, ACTION, PERFORMER_TYPE, DETAIL_VALUE, COMPLETION_TIME) "
//									 	+ "values(HIBERNATE_SEQUENCE.NEXTVAL, ?1, ?2, ?3, ?4,?5, ?6, ?7)", nativeQuery=true)
//	String createAccountActivityLogNative(Long userProfileId, boolean status,
//			String activity_type, String action, String performer_type,
//			String detail, Date completionTime);

	@Transactional
	@Procedure(value ="MHV_ACTIVITY_ENTRY")
	public void createAccountActivityLogSpc(Long userId, String activity_type, String action, String detail_value, 
						String performer_type, Boolean status, Date completionTime);
	
}
